
# Coo'print

Aujourd'hui beaucoup de designer.euses et de projets de design font appel aux pratiques collectives, mais les outils numériques traditionnels du design graphique ont tendance à cloisonner les pratiques. Comment faire pour travailler à plusieurs ? Comment concevoir ensemble ? Quels outils permettent de faire ensemble ? Ce workshop vise à mettre en place une publication imprimée conçut à plusieurs, en collectif, libre et ouverte. Standards et ouverts, le web et ses outils se sont construit sur la mise en place de langages et d'espace de collaborations. 

Réalisée à l'ESAAT ROUBAIX et les étudiant.es du DSAA mention Graphisme l'édition est conçue et développé avec les langages du web \: HTML, CSS et JavaScript. L'éditorialisation et la mise en page des contenus sont rédigés sur deux pads*. Un des pad (disponible [ici](https://annuel2.framapad.org/p/contantcooprint-9z4l?lang=en)) est dédié au contenu (rédigé en markdown) et un autre (disponible [ici](https://annuel2.framapad.org/p/cessatroubaix-9z4l?lang=en)) à la mise en forme (CSS). Ils sont hébergés pour une durée limité sur Framapad un service de Framasoft. Pour utiliser le navigateur comme interface de visualisation et d'exportation en pdf, la bibliothèque JavaScript [paged.js](https://pagedjs.org) a été utilisé.

*\* Un « pad » est un éditeur de texte collaboratif en ligne. Les contributions de chaque utilisateur sont signalées par un code couleur, apparaissent à l’écran en temps réel et sont enregistrées au fur et à mesure qu’elles sont tapées.*  

## Textes \: 
- "Manifeste pour une guérilla en faveur du libre accès", Aaron Swartz (disponible [ici](https://framablog.org/2013/01/14/manifeste-guerilla-libre-acces-aaron-swartz/)) ;
- "Open Source Publishing, Relearn", f-u-t-u-r-e.org (disponible [ici](http://f-u-t-u-r-e.org/r/02_OSP_Relearn_FR.md)) ;
- "No-one Starts From Scratch \: Type Design and the logic of the fork", Eric Schrijver (disponible [ici](https://i.liketightpants.net/and/no-one-starts-from-scratch-type-design-and-the-logic-of-the-fork));
- "Trouble dans le genre ­— pédagogie alternative de l’édition hybride", Loraine Furter (disponible [ici](https://www.design-research.be/hybrid/publications.html)) ;
- "Dégooglisons Internet", Framasoft (disponible [ici](https://framablog.org/2014/10/07/degooglisons-internet/)) ;
- "Fedizine, an anarchist introduction to federated social media" (disponible [ici](https://distro.f-91w.club/fedizine/)) ;
- "OSP Visual culture", Anthony Masure (disponible [ici](http://www.strabic.fr/OSP-Visual-Culture)) ;
- "Être maladroit..e avec soi, avec les autres, au futur", Philippine Talamona (disponible [ici](https://clumsyfemlab.philippinetalamona.com/#etre-maladroite-avec-soi-avec-les-autres-au-futur)) ;
- [À faire] Meta-manuels (Documenter la chaîne éditoriale)
    - comment faire une publication à plusieurs; 
    - Comment refaire le livre chez vous; 

----

## Resources \:
- Memo HTML (disponible [ici](https://www.simplehtmlguide.com/cheatsheet.php)) ;
- Memo CSS (disponible [ici](https://devhints.io/css) et [là](https://htmlcheatsheet.com/css/)) ;
- CSS print \: comment utiliser les feuilles de styles pour mettre en page un livre (disponible ici [ici](https://sarahgarcin.com/workshops/coding-cooking/web2print.html)) ;
- Comment mettre en forme des gabarits de pages pour l'imprimé [documentation paged.js](https://pagedjs.org/documentation/) ; 
- Un markdown pour les chaînes de publications (disponible [ici]()) ;
- Liste de typographie [en ligne](https://gitlab.com/quentinjuhel/Libre-typo) ;

## Références \: 
- [Controverse, Modes d'emploi](https://controverses.org/mode-demploi/#container-menu-pres) ;
- [Copy this book](https://copy-this-book.eu/) ;
- [La villa Chiragan](https://julie-blanc.fr/projects/villa-chiragan/) ;
- [Print it](https://print-it.objetpapier.fr/);
- [Each page a function](https://raphaelbastide.com/epaf/zine/);
- [Medo](https://medor.coop/)